<?php
include "session.php"; include "functions.php";
if ((!$rPermissions["is_admin"]) OR (!hasPermissions("adv", "servers"))) { exit; }

if ($rSettings["sidebar"]) {
    include "header_sidebar.php";
} else {
    include "header.php";
}
        if ($rSettings["sidebar"]) { ?>
        <div class="content-page"><div class="content"><div class="container-fluid">
        <?php } else { ?>
        <div class="wrapper"><div class="container-fluid">
        <?php } ?>
                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li>
                                        <a href="javascript:location.reload();">
                                            <button type="button" class="btn btn-dark waves-effect waves-light btn-sm">
                                                <i class="mdi mdi-refresh"></i> <?=$_["refresh"]?> 
                                            </button>
                                        </a>
										<?php if (hasPermissions("adv", "add_server")) { ?>
                                        <a href="server.php">
                                            <button type="button" class="btn btn-success waves-effect waves-light btn-sm">
                                                <i class="mdi mdi-plus"></i> <?=$_["add_server"]?> 
                                            </button>
                                        </a>
                                        <a href="install_server.php">
                                            <button type="button" class="btn btn-info waves-effect waves-light btn-sm">
                                                <i class="mdi mdi-creation"></i> <?=$_["install_lb"]?> 
                                            </button>
                                        </a>
										<?php } ?>
                                    </li>
                                </ol>
                            </div>
                            <h4 class="page-title"><?=$_["servers"]?> </h4>
                        </div>
                    </div>
                </div>     
                <!-- end page title --> 

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body" style="overflow-x:auto;">
                                <table id="datatable" class="table table-hover dt-responsive nowrap">
                                    <thead>
                                        <tr>
                                            <th class="text-center"><?=$_["id"]?></th>
											<th class="text-center"><?=$_["actions"]?></th>
                                            <th class="text-center"><?=$_["server_name"]?></th>
                                            <th class="text-center"><?=$_["status"]?></th>
                                            <th class="text-center"><?=$_["uptime"]?></th>
											<th class="text-center"><?=$_["healt"]?></th>
                                            <th class="text-center"><?=$_["server_info"]?></th>
                                            <th class="text-center"><?=$_["domaine_name"]?></th>
                                            <th class="text-center"><?=$_["server_ip"]?></th>
											<th class="text-center"><?=$_["ports"]?> </th>
                                            <th class="text-center"><?=$_["client"]?></th>
                                            <th class="text-center"><?=$_["cpu_%"]?></th>
                                            <th class="text-center"><?=$_["mem_%"]?></th>
											<th class="text-center"><?=$_["in"]?></th>
											<th class="text-center"><?=$_["out"]?></th>
											<th class="text-center"><?=$_["network_speed_guaranteed"]?></th>
                                            
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($rServers as $rServer) {
                                        if (((time() - $rServer["last_check_ago"]) > 360) AND ($rServer["can_delete"] == 1) AND ($rServer["status"] <> 3)) { $rServer["status"] = 2; } // Server Timeout
                                        if (in_array($rServer["status"], Array(0,1))) {
                                            $rServerText = Array(0 => "Disabled", 1 => "Online")[$rServer["status"]];
                                        } else if ($rServer["status"] == 2) {
                                            if ($rServer["last_check_ago"] > 0) {
                                                $rServerText = "Offline for ".intval((time() - $rServer["last_check_ago"])/60)." minutes";
                                            } else {
                                                $rServerText = "Offline";
                                            }
                                        } else if ($rServer["status"] == 3) {
                                            $rServerText = "Installing...";
                                        }
										
										$rLatency = $rServer["latency"] * 1000;
										if ($rLatency > 0) {
											$rLatency = $rLatency." ms";
										} else {
											$rLatency = "";
										}
										
										$rWatchDog = json_decode($rServer["watchdog_data"], True);
										$rServerHardware = json_decode($rServer["server_hardware"], true);
										$total_disk = $rWatchDog["total_disk_space"] / 1000000000;
										$gbtotal_used = $rServerHardware["total_used"] / 1000000;
										$gbtotal_ram = $rServerHardware["total_ram"] / 1000000;
										$gbitnetworkspeed = $rServerHardware["network_speed"] / 1000;
										$inNetworkLoad = $rWatchDog["bytes_received"] / $rServer["network_guaranteed_speed"] * 100;
                                        $outNetworkLoad = $rWatchDog["bytes_sent"] / $rServer["network_guaranteed_speed"] * 100;
										$healt_server_ram = $rWatchDog["total_mem_used_percent"];
										
										if ($healt_server_ram > 90) {
                                            $healt_server = "<span class='text-danger'</span>High RAM"; 
										} else if ($healt_server_ram > 75) {
											$healt_server = "<span class='text-warning'</span>High RAM";
											
                                        } else if (($rWatchDog["cpu_avg"]) > 90) {
                                            $healt_server = "<span class='text-danger'</span>High CPU";
										} else if (($rWatchDog["cpu_avg"]) > 75) {	
											$healt_server = "<span class='text-warning'</span>High CPU";
											
											
                                        } else if ($outNetworkLoad > 90) {
                                            $healt_server = "<span class='text-danger'</span>Overloading OUT bandwidth";
										} else if ($outNetworkLoad > 75) {	
										    $healt_server = "<span class='text-warning'</span>Overloading OUT bandwidth";
											
                                        } else if ($inNetworkLoad > 90) {
                                            $healt_server = "<span class='text-danger'</span>Overloading IN bandwidth";
										} else if ($inNetworkLoad > 75) {
  											$healt_server = "<span class='text-warning'</span>Overloading IN bandwidth";
											
										} else if ($rServer["status"] == 2) {
											$healt_server = "<span class='text-danger'</span>Offline";
											
										} else if ($rServer["status"] == 3) {
											$healt_server = "<span class='text-info'</span>Installing...";
											
                                        } else {
                                            $healt_server = "<span class='text-success'</span>OK";
                                        }
                                        ?>
                                        <tr id="server-<?=$rServer["id"]?>">

                                            <td class="text-center"><a href="./server.php?id=<?=$rServer["id"]?>"><?=$rServer["id"]?></td>
											
											<td class="text-center">
												<?php if (hasPermissions("adv", "edit_server")) { ?>
                                                <div class="btn-group">

												    <?php if ($rServer["can_delete"] == 0) { ?>
                                                    <button type="button" data-toggle="tooltip" data-placement="top" title="" data-original-title="<?=$_["advanced_functions_for_servers"]?>" class="btn btn-danger waves-effect waves-light btn-xs btn-functions-server" data-ssh1="<?=$rServer["ssh_port"]?>" data-ssh2="<?=base64_decode(base64_decode($rServer["ssh_password"]))?>" data-id="<?=$rServer["id"]?>"><?=$_["options"]?></button>
													<?php } else { ?>
													<button type="button" data-toggle="tooltip" data-placement="top" title="" data-original-title="<?=$_["advanced_functions_for_balance"]?>" class="btn btn-secondary waves-effect waves-light btn-xs btn-functions-balancer" data-ssh1="<?=$rServer["ssh_port"]?>" data-ssh2="<?=base64_decode(base64_decode($rServer["ssh_password"]))?>" data-id="<?=$rServer["id"]?>"><?=$_["options"]?></button>
													<?php } ?>
												
												    <button type="button" class="btn btn-dark waves-effect waves-light btn-xs" data-toggle="dropdown" aria-expanded="true"><i class="fas fa-caret-down" style="font-size:15px"></i></button>
					                                <div class="dropdown-menu dropdown-menu-dark dropright" aria-labelledby="dropdownMenu1">

													<a href="./ip_change.php" class="dropdown-item"><?=$_["ip_change"]?></button></a>
													
                                                    <a class="dropdown-item" href="javascript: void(0);" onClick="api(<?=$rServer["id"]?>, 'start');"><?=$_["start_all_servers"]?></i></a>
													
                                                    <a class="dropdown-item" href="javascript: void(0);" onClick="api(<?=$rServer["id"]?>, 'stop');"><?=$_["stop_all_streams"]?></a>
													
                                                    <a class="dropdown-item" href="javascript: void(0);" onClick="api(<?=$rServer["id"]?>, 'kill');"><?=$_["kill_all_connections"]?></a>
													
                                                    <a href="./server.php?id=<?=$rServer["id"]?>" class="dropdown-item"><?=$_["edit_server"]?></a>
													
                                                    <?php if ($rServer["can_delete"] == 1) { ?>
                                                    <a class="dropdown-item text-danger" href="javascript: void(0);" onClick="api(<?=$rServer["id"]?>, 'delete');"><?=$_["delete_server"]?></a>
                                                    <?php } else { ?>
                                                    <?php } ?>
                                                </div>
												<?php } else { echo "--"; } ?>
                                            </td>
											
                                            <td><a href="./server.php?id=<?=$rServer["id"]?>"><?=$rServer["server_name"]?></td>
                                            <td data-toggle="tooltip" data-placement="top" title="" data-original-title="<?=$rServerText?>" class="text-center"><i class="<?php if ($rServer["status"] == 1) { echo "text-success"; } else if ($rServer["status"] == "3") { echo "text-info"; } else { echo "text-danger"; } ?> fas fa-<?=Array(0 => "square", 1 => "square text-success", 2 => "square text-danger", 3 => "square text-info")[$rServer["status"]]?>"></i> <?=$rLatency?></td>
                                            <td class="text-center"><?=$rWatchDog["uptime"]?></td>
											<td class="text-center"><?=$healt_server?></td>
                                            <td><?=$rServerHardware["cpu_name"]?><br><?=$rWatchDog["cpu_cores"]?> <?=$_["cores_load_average"]?> <?=$rWatchDog["cpu_load_average"]?><br> <?=$_["Mem_usage"]?> <?=intval($gbtotal_used)?>G of <?=intval($gbtotal_ram)?><?=$_["g_disk"]?> <?=intval($total_disk)?>G</td>
                                            <td><?=$rServer["domain_name"]?></td>
                                            <td><?=$rServer["server_ip"]?></td>
											<td class="text-center"><?=$rServer["http_broadcast_port"]?><br><?=$rServer["https_broadcast_port"]?></td>
											<?php if (hasPermissions("adv", "live_connections")) { ?>
                                            <td class="text-center"><a href="./live_connections.php?server_id=<?=$rServer["id"]?>"><button type="button" class="btn btn-secondary btn-xs waves-effect waves-light"><?=count(getConnections($rServer["id"]))?></button></a></td>
											<?php } else { ?>
											<td class="text-center"><?=count(getConnections($rServer["id"]))?> / <?=$rServer["total_clients"]?></td>
											<?php } ?>
                                            <td class="text-center"><button class="btn btn-pink waves-effect waves-light btn-xs"><?=intval($rWatchDog["cpu_avg"])?>%</a></td></button>
                                            <td class="text-center"><button class="btn btn-pink waves-effect waves-light btn-xs"><?=intval($rWatchDog["total_mem_used_percent"])?>%</a></td></button>
											<td class="text-center"><button class="btn btn-info waves-effect waves-light btn-xs"><?=intval($inNetworkLoad)?>%</td></button>
											<td class="text-center"><button class="btn btn-info waves-effect waves-light btn-xs"><?=intval($outNetworkLoad)?>%</td></button>
											<td><?=$rServer["network_interface"]?> = <?=$gbitnetworkspeed?> Gbit/s - <?=$rServer["network_guaranteed_speed"]?> Mbit/s</td>
                                            
                                        </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div> <!-- end card body-->
                        </div> <!-- end card -->
                    </div><!-- end col-->
                </div>
                <!-- end row-->
            </div> <!-- end container -->
        </div>
        <div class="modal fade bs-server-modal-center" tabindex="-1" role="dialog" aria-labelledby="MainLabel" aria-hidden="true" style="display: none;" data-id="">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h6 class="modal-title w-100 text-center" id="MainLabel"><?=$_["advanced_functions_for_servers"]?></h6>
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group row mb-4">
							<div class="col-md-6">
								<input id="restart_server_ssh" type="submit" class="btn btn-info" value="<?=$_["restart_services"]?>" style="width:100%" /></p>
							</div>
							<div class="col-md-6">
								<input id="reboot_server_ssh" type="submit" class="btn btn-info" value="<?=$_["reboot_server"]?>" style="width:100%" /></p>
							</div>
						</div>
						<div class="form-group row mb-4">
							<div class="col-md-6">
								<input id="remake_server_ssh" type="submit" class="btn btn-dark" value="<?=$_["remake_server"]?>" style="width:100%" /></p>
							</div>
							<div class="col-md-6">
							    <input id="fremake_server_ssh" type="submit" class="btn btn-dark" value="<?=$_["fremake_server"]?>" style="width:100%" /></p>
                            </div>
						</div>
						<!--<div class="form-group row mb-4">
							<div class="col-md-6 mx-auto">
								<input id="update_release_ssh" type="submit" class="btn btn-danger" value="<?=$_["update_release"]?>" style="width:100%" /></p>
							</div>
						</div>-->
                    </div>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->
		<div class="modal fade bs-balancer-modal-center" tabindex="-1" role="dialog" aria-labelledby="BalancerLabel" aria-hidden="true" style="display: none;" data-id="">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h6 class="modal-title w-100 text-center" id="BalancerLabel"><?=$_["advanced_functions_for_balance"]?></h6>
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    </div>
                    <div class="modal-body">
					    <div class="form-group row mb-4">
							<div class="col-md-6">
								<input id="restart_balancer_ssh" type="submit" class="btn btn-info" value="<?=$_["restart_services"]?>" style="width:100%" /></p>
							</div>
							<div class="col-md-6">
								<input id="reboot_balancer_ssh" type="submit" class="btn btn-info" value="<?=$_["reboot_server"]?>" style="width:100%" /></p>
							</div>
						</div>
					    <div class="form-group row mb-4">
							<div class="col-md-6">
								<input id="remake_balancer_ssh" type="submit" class="btn btn-secondary" value="<?=$_["remake_balancer"]?>" style="width:100%" /></p>
							</div>
							<div class="col-md-6">
							    <input id="fremake_balancer_ssh" type="submit" class="btn btn-secondary" value="<?=$_["fremake_balancer"]?>" style="width:100%" /></p>
							</div>
						</div>
						<div class="form-group row mb-4">
							<div class="col-md-6">
								<input id="update_geolite_ssh" type="submit" class="btn btn-secondary" value="<?=$_["update_geolite"]?>" style="width:100%" /></p>
							</div>
							<div class="col-md-6">
								<input id="update_youtube_ssh" type="submit" class="btn btn-secondary" value="<?=$_["update_youtube"]?>" style="width:100%" /></p>
							</div>
						</div>
					</div>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->
        <!-- end wrapper -->
        <?php if ($rSettings["sidebar"]) { echo "</div>"; } ?>
        <!-- Footer Start -->
        <footer class="footer">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 copyright text-center"><?=getFooter()?></div>
                </div>
            </div>
        </footer>
        <!-- end Footer -->

        <script src="assets/js/vendor.min.js"></script>
        <script src="assets/libs/jquery-toast/jquery.toast.min.js"></script>
        <script src="assets/libs/datatables/jquery.dataTables.min.js"></script>
        <script src="assets/libs/datatables/dataTables.bootstrap4.js"></script>
        <script src="assets/libs/datatables/dataTables.responsive.min.js"></script>
        <script src="assets/libs/datatables/responsive.bootstrap4.min.js"></script>
        <script src="assets/libs/datatables/dataTables.buttons.min.js"></script>
        <script src="assets/libs/datatables/buttons.bootstrap4.min.js"></script>
        <script src="assets/libs/datatables/buttons.html5.min.js"></script>
        <script src="assets/libs/datatables/buttons.flash.min.js"></script>
        <script src="assets/libs/datatables/buttons.print.min.js"></script>
        <script src="assets/libs/datatables/dataTables.keyTable.min.js"></script>
        <script src="assets/libs/datatables/dataTables.select.min.js"></script>
		<script src="assets/libs/jquery-knob/jquery.knob.min.js"></script>	
        <script src="assets/js/app.min.js"></script>

        <script>
        function api(rID, rType) {
            if (rType == "delete") {
                if (confirm('<?=$_["are_you_sure_you_want_to_delete_this_server"]?>') == false) {
                    return;
                }
            } else if (rType == "kill") {
                if (confirm('<?=$_["are_you_sure_you_want_to_kill_all_servers"]?>') == false) {
                    return;
                }
            } else if (rType == "start") {
                if (confirm('<?=$_["are_you_sure_you_want_to_start_all_severs"]?>') == false) {
                    return;
                }
            } else if (rType == "stop") {
                if (confirm('<?=$_["are_you_sure_you_want_to_stop_all_streams"]?>') == false) {
                    return;
                }
            }
            $.getJSON("./api.php?action=server&sub=" + rType + "&server_id=" + rID, function(data) {
                if (data.result === true) {
                    if (rType == "delete") {
                        $("#server-" + rID).remove();
                        $.each($('.tooltip'), function (index, element) {
                            $(this).remove();
                        });
                        $('[data-toggle="tooltip"]').tooltip();
                        $.toast("<?=$_["server_successfully_deleted"]?>");
                    } else if (rType == "kill") {
                        $.toast("<?=$_["all_server_connections_have_been_killed"]?>");
                    } else if (rType == "start") {
                        $.toast("<?=$_["all_server_connections_have_been_started"]?>");
                    } else if (rType == "stop") {
                        $.toast("<?=$_["all_server_connections_have_been_stopped"]?>");
                    }
                } else {
                    $.toast("<?=$_["an_error_occured_while_processing_your_request"]?>");
                }
            });
        }
        $("#restart_server_ssh").click(function() {
            $(".bs-server-modal-center").modal("hide");
            $.getJSON("./api.php?action=restart_services&ssh_port=" + $(".bs-server-modal-center").data("ssh1") + "&server_id=" + $(".bs-server-modal-center").data("id") + "&password=" + $(".bs-server-modal-center").data("ssh2"), function(data) {
                if (data.result === true) {
                    $.toast("<?=$_["services_will_be_restarted_shortly"]?>");
                } else {
                    $.toast("<?=$_["an_error_occured_while_processing_your_request"]?>");
                }
                $(".bs-server-modal-center").data("id", "");
				$(".bs-server-modal-center").data("ssh1", "");
				$(".bs-server-modal-center").data("ssh2", "");

            });
        });
		$("#reboot_server_ssh").click(function() {
            $(".bs-server-modal-center").modal("hide");
            $.getJSON("./api.php?action=reboot_server&ssh_port=" + $(".bs-server-modal-center").data("ssh1") + "&server_id=" + $(".bs-server-modal-center").data("id") + "&password=" + $(".bs-server-modal-center").data("ssh2"), function(data) {
                if (data.result === true) {
                    $.toast("<?=$_["server_will_be_restarted_shortly"]?>");
                } else {
                    $.toast("<?=$_["an_error_occured_while_processing_your_request"]?>");
                }
                $(".bs-server-modal-center").data("id", "");
				$(".bs-server-modal-center").data("ssh1", "");
				$(".bs-server-modal-center").data("ssh2", "");

            });
        });
		$("#remake_server_ssh").click(function() {
            $(".bs-server-modal-center").modal("hide");
            $.getJSON("./api.php?action=remake_server&ssh_port=" + $(".bs-server-modal-center").data("ssh1") + "&server_id=" + $(".bs-server-modal-center").data("id") + "&password=" + $(".bs-server-modal-center").data("ssh2"), function(data) {
                if (data.result === true) {
                    $.toast(" <?=$_["main_will_be_remaked_shortly"]?>");
                } else {
                    $.toast(" <?=$_["an_error_occured_while_processing_your_request"]?>");
                }
                $(".bs-server-modal-center").data("id", "");
				$(".bs-server-modal-center").data("ssh1", "");
				$(".bs-server-modal-center").data("ssh2", "");

            });
        });
		$("#fremake_server_ssh").click(function() {
            $(".bs-server-modal-center").modal("hide");
            $.getJSON("./api.php?action=fremake_server&ssh_port=" + $(".bs-server-modal-center").data("ssh1") + "&server_id=" + $(".bs-server-modal-center").data("id") + "&password=" + $(".bs-server-modal-center").data("ssh2"), function(data) {
                if (data.result === true) {
                    $.toast(" <?=$_["server_will_be_full_remaked_shortly"]?>");
                } else {
                    $.toast(" <?=$_["an_error_occured_while_processing_your_request"]?>");
                }
                $(".bs-server-modal-center").data("id", "");
				$(".bs-server-modal-center").data("ssh1", "");
				$(".bs-server-modal-center").data("ssh2", "");

            });
        });
		$("#update_release_ssh").click(function() {
            $(".bs-server-modal-center").modal("hide");
            $.getJSON("./api.php?action=update_release&ssh_port=" + $(".bs-server-modal-center").data("ssh1") + "&server_id=" + $(".bs-server-modal-center").data("id") + "&password=" + $(".bs-server-modal-center").data("ssh2"), function(data) {
                if (data.result === true) {
                    $.toast(" <?=$_["release_will_be_updated_shortly"]?>");
                } else {
                    $.toast(" <?=$_["an_error_occured_while_processing_your_request"]?>");
                }					 
                $(".bs-server-modal-center").data("id", "");
				$(".bs-server-modal-center").data("ssh1", "");
				$(".bs-server-modal-center").data("ssh2", "");

            });
        });
		$("#restart_balancer_ssh").click(function() {
            $(".bs-balancer-modal-center").modal("hide");
            $.getJSON("./api.php?action=restart_services&ssh_port=" + $(".bs-balancer-modal-center").data("ssh1") + "&server_id=" + $(".bs-balancer-modal-center").data("id") + "&password=" + $(".bs-balancer-modal-center").data("ssh2"), function(data) {
                if (data.result === true) {
                    $.toast("<?=$_["services_will_be_restarted_shortly"]?>");
                } else {
                    $.toast("<?=$_["an_error_occured_while_processing_your_request"]?>");
                }
                $(".bs-balancer-modal-center").data("id", "");
				$(".bs-balancer-modal-center").data("ssh1", "");
				$(".bs-balancer-modal-center").data("ssh2", "");

            });
        });
		$("#reboot_balancer_ssh").click(function() {
            $(".bs-balancer-modal-center").modal("hide");
            $.getJSON("./api.php?action=reboot_server&ssh_port=" + $(".bs-balancer-modal-center").data("ssh1") + "&server_id=" + $(".bs-balancer-modal-center").data("id") + "&password=" + $(".bs-balancer-modal-center").data("ssh2"), function(data) {
                if (data.result === true) {
                    $.toast("<?=$_["server_will_be_restarted_shortly"]?>");
                } else {
                    $.toast("<?=$_["an_error_occured_while_processing_your_request"]?>");
                }
                $(".bs-balancer-modal-center").data("id", "");
				$(".bs-balancer-modal-center").data("ssh1", "");
				$(".bs-balancer-modal-center").data("ssh2", "");

            });
        });
		$("#remake_balancer_ssh").click(function() {
            $(".bs-balancer-modal-center").modal("hide");
            $.getJSON("./api.php?action=remake_balancer&ssh_port=" + $(".bs-balancer-modal-center").data("ssh1") + "&server_id=" + $(".bs-balancer-modal-center").data("id") + "&password=" + $(".bs-balancer-modal-center").data("ssh2"), function(data) {
                if (data.result === true) {
                    $.toast(" <?=$_["balancer_will_be_remaked_shortly"]?>");
                } else {
                    $.toast(" <?=$_["an_error_occured_while_processing_your_request"]?>");
                }
                $(".bs-balancer-modal-center").data("id", "");
				$(".bs-balancer-modal-center").data("ssh1", "");
				$(".bs-balancer-modal-center").data("ssh2", "");

            });
        });
		$("#fremake_balancer_ssh").click(function() {
            $(".bs-balancer-modal-center").modal("hide");
            $.getJSON("./api.php?action=fremake_balancer&ssh_port=" + $(".bs-balancer-modal-center").data("ssh1") + "&server_id=" + $(".bs-balancer-modal-center").data("id") + "&password=" + $(".bs-balancer-modal-center").data("ssh2"), function(data) {
                if (data.result === true) {
                    $.toast(" <?=$_["balancer_will_be_full_remaked_shortly"]?>");
                } else {
                    $.toast(" <?=$_["an_error_occured_while_processing_your_request"]?>");
                }
                $(".bs-balancer-modal-center").data("id", "");
				$(".bs-balancer-modal-center").data("ssh1", "");
				$(".bs-balancer-modal-center").data("ssh2", "");

            });
        });
		$("#update_geolite_ssh").click(function() {
            $(".bs-balancer-modal-center").modal("hide");
            $.getJSON("./api.php?action=update_geolite&ssh_port=" + $(".bs-balancer-modal-center").data("ssh1") + "&server_id=" + $(".bs-balancer-modal-center").data("id") + "&password=" + $(".bs-balancer-modal-center").data("ssh2"), function(data) {
                if (data.result === true) {
                    $.toast(" <?=$_["balancer_will_be_update_geolite_shortly"]?>");
                } else {
                    $.toast(" <?=$_["an_error_occured_while_processing_your_request"]?>");
                }
                $(".bs-balancer-modal-center").data("id", "");
				$(".bs-balancer-modal-center").data("ssh1", "");
				$(".bs-balancer-modal-center").data("ssh2", "");

            });
        });
		$("#update_youtube_ssh").click(function() {
            $(".bs-balancer-modal-center").modal("hide");
            $.getJSON("./api.php?action=update_youtube&ssh_port=" + $(".bs-balancer-modal-center").data("ssh1") + "&server_id=" + $(".bs-balancer-modal-center").data("id") + "&password=" + $(".bs-balancer-modal-center").data("ssh2"), function(data) {
                if (data.result === true) {
                    $.toast(" <?=$_["balancer_will_be_update_youtube_dl_shortly"]?>");
                } else {
                    $.toast(" <?=$_["an_error_occured_while_processing_your_request"]?>");
                }
                $(".bs-balancer-modal-center").data("id", "");
				$(".bs-balancer-modal-center").data("ssh1", "");
				$(".bs-balancer-modal-center").data("ssh2", "");

            });
        });
        $(".btn-functions-server").click(function() {
            $(".bs-server-modal-center").data("id", $(this).data("id"));
			$(".bs-server-modal-center").data("ssh1", $(this).data("ssh1"));
			$(".bs-server-modal-center").data("ssh2", $(this).data("ssh2"));
            $(".bs-server-modal-center").modal("show");
        });
		$(".btn-functions-balancer").click(function() {
            $(".bs-balancer-modal-center").data("id", $(this).data("id"));
			$(".bs-balancer-modal-center").data("ssh1", $(this).data("ssh1"));
			$(".bs-balancer-modal-center").data("ssh2", $(this).data("ssh2"));
            $(".bs-balancer-modal-center").modal("show");
        });
        $(document).ready(function() {
            $("#datatable").DataTable({
                language: {
                    paginate: {
                        previous: "<i class='mdi mdi-chevron-left'>",
                        next: "<i class='mdi mdi-chevron-right'>"
                    }
                },
                drawCallback: function() {
                    $(".dataTables_paginate > .pagination").addClass("pagination");
                },
                pageLength: 50,
                lengthMenu: [10, 25, 50, 100, 250],
                responsive: false,
				columnDefs: [
                    <?php if ($rPermissions["is_admin"]) { ?>
                    {"orderable": false, "targets": [1,5,8,10,11,12,13,14]}
                    <?php } else { ?>
                    {"className": "dt-center", "targets": []}
                    <?php } ?>
                ],
				stateSave: true
				
				});
            $("#datatable").css("width", "100%");
        });				  
        </script>
    </body>
</html>