<?php
include "session.php"; include "functions.php";

//start
$starttime = microtime(true);
if ($rPermissions["is_admin"]) {
    $sql = "SELECT a.stream_id, sum(a.date_end)-sum(a.date_start) AS watched, s.stream_display_name FROM user_activity AS a JOIN streams AS s ON a.stream_id=s.id WHERE s.type=2 GROUP BY a.stream_id  ORDER BY watched DESC LIMIT 100";
	}
$result = $db->query($sql);
$array = [];
while ($row = $result->fetch_assoc()) {
    $array[] = ["stream_display_name" => $row["stream_display_name"], "wateched" => $row["watched"]];
}
$endtime = microtime(true);
//end

if ($rSettings["sidebar"]) {
    include "header_sidebar.php";
} else {
    include "header.php";
}
        if ($rSettings["sidebar"]) { ?>
        <div class="content-page"><div class="content boxed-layout-ext"><div class="container-fluid">
        <?php } else { ?>
        <div class="wrapper boxed-layout-ext"><div class="container-fluid">
        <?php } ?>
                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
						    <div class="page-title-right">
                                <ol class="breadcrumb m-0">
									<li>
                                        <a href="./movies.php">
								        <button type="button" class="btn btn-primary waves-effect waves-light btn-sm"><i class="mdi mdi-keyboard-backspace"></i> <?=$_["back_to_movies"]?></button>
									    </a>	
                                    </li>
                                </ol>
                            </div>
                            <h4 class="page-title"><?=$_["movies_statistics"]?></h4>
                        </div>
                    </div>
                </div>     
                <!-- end page title --> 
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body" style="overflow-x:auto;">
                                <table id="datatable" class="table table-hover dt-responsive nowrap">
                                    <thead>
                                        <tr>
                                            <th><?=$_["id"]?> </th>
                                            <th><?=$_["stream_name"]?> </th>
                                            <th><?=$_["total_time"]?> </th>											
                                        </tr>
                                    </thead>
                                    <tbody>
									    <?php if (0 < count($array)) { ?>
										<?php $i = 1; foreach ($array as $arr) { ?>
                                        <tr>
                                            <td><?php echo $i; $i++;?></td>
											<td><?php echo $arr["stream_display_name"];?></td>
											<td><button type="button" class="btn btn-success btn-xs btn-fixed waves-effect waves-light"><?php echo sprintf("%02dh %02dm %02ds", $arr["wateched"] / 3600, $arr["wateched"] / 60 % 60, $arr["wateched"] % 60);?></td>
                                        </tr>
										<?php } } ?>
                                    </tbody>
                                </table>

                            </div> <!-- end card body-->
                        </div> <!-- end card -->
                    </div><!-- end col-->
                </div>
                <!-- end row-->
            </div> <!-- end container -->
        </div>
        <!-- end wrapper -->
        <?php if ($rSettings["sidebar"]) { echo "</div>"; } ?>
        <!-- Footer Start -->
        <footer class="footer">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 copyright text-center"><?=getFooter()?></div>
                </div>
            </div>
        </footer>
        <!-- end Footer -->

        <script src="assets/js/vendor.min.js"></script>
        <script src="assets/libs/jquery-toast/jquery.toast.min.js"></script>
        <script src="assets/libs/datatables/jquery.dataTables.min.js"></script>
        <script src="assets/libs/datatables/dataTables.bootstrap4.js"></script>
		<script src="assets/libs/select2/select2.min.js"></script>
        <script src="assets/libs/datatables/dataTables.responsive.min.js"></script>
        <script src="assets/libs/datatables/responsive.bootstrap4.min.js"></script>
        <script src="assets/libs/datatables/dataTables.buttons.min.js"></script>
        <script src="assets/libs/datatables/buttons.bootstrap4.min.js"></script>
        <script src="assets/libs/datatables/buttons.html5.min.js"></script>
        <script src="assets/libs/datatables/buttons.flash.min.js"></script>
        <script src="assets/libs/datatables/buttons.print.min.js"></script>
        <script src="assets/libs/datatables/dataTables.keyTable.min.js"></script>
        <script src="assets/libs/datatables/dataTables.select.min.js"></script>
		<script src="assets/libs/moment/moment.min.js"></script>
		<script src="assets/libs/daterangepicker/daterangepicker.js"></script>
        <script src="assets/js/app.min.js"></script>

        <!-- Datatables init -->
        <script>
        $(document).ready(function() {		
            $("#datatable").DataTable({
                language: {
                    paginate: {
                        previous: "<i class='mdi mdi-chevron-left'>",
                        next: "<i class='mdi mdi-chevron-right'>"
                    }
                },
				columnDefs: [
                    {"className": "dt-center", "targets": [0,1,2]},
					{"orderable": true, "targets": [0,1,2]},
                    {"visible": false, "targets": []}
                ],
                drawCallback: function() {
                    $(".dataTables_paginate > .pagination").addClass("pagination");
					$('[data-toggle="tooltip"]').tooltip();
                },
                pageLength: 10,
                lengthMenu: [10, 25, 50, 100],
                responsive: false,
				stateSave: true
            });
            $("#datatable").css("width", "100%");
        });
        </script>
    </body>
</html>