<?php if (count(get_included_files()) == 1) { exit; }
if ($rPermissions["is_admin"]) {
    $rCheckTickets = getTickets();
}  
 ?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <title><?=htmlspecialchars($rSettings["server_name"])?></title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="robots" content="noindex,nofollow">
        <link rel="shortcut icon" href="assets/images/favicon.ico">
        <link href="assets/libs/jquery-nice-select/nice-select.css" rel="stylesheet" type="text/css" />
        <link href="assets/libs/switchery/switchery.min.css" rel="stylesheet" type="text/css" />
        <link href="assets/libs/select2/select2.min.css" rel="stylesheet" type="text/css" />
        <link href="assets/libs/datatables/dataTables.bootstrap4.css" rel="stylesheet" type="text/css" />
        <link href="assets/libs/datatables/responsive.bootstrap4.css" rel="stylesheet" type="text/css" />
        <link href="assets/libs/datatables/buttons.bootstrap4.css" rel="stylesheet" type="text/css" />
        <link href="assets/libs/datatables/select.bootstrap4.css" rel="stylesheet" type="text/css" />
        <link href="assets/libs/jquery-toast/jquery.toast.min.css" rel="stylesheet" type="text/css" />
        <link href="assets/libs/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" type="text/css" />
        <link href="assets/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.css" rel="stylesheet" type="text/css" />
        <link href="assets/libs/treeview/style.css" rel="stylesheet" type="text/css" />
        <link href="assets/libs/clockpicker/bootstrap-clockpicker.min.css" rel="stylesheet" type="text/css" />
        <link href="assets/libs/daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
        <link href="assets/libs/nestable2/jquery.nestable.min.css" rel="stylesheet" />
        <link href="assets/libs/magnific-popup/magnific-popup.css" rel="stylesheet" type="text/css" />
        <link href="assets/libs/bootstrap-colorpicker/bootstrap-colorpicker.min.css" rel="stylesheet" type="text/css" />
		<link href="assets/css/icons.css" rel="stylesheet" type="text/css" />
		<?php if (!$rAdminSettings["dark_mode"]) { ?>
        <link href="assets/css/bootstrap.css" rel="stylesheet" type="text/css" />
        <link href="assets/css/app.css" rel="stylesheet" type="text/css" />
		<?php } else { ?>
		<link href="assets/css/bootstrap.dark.css" rel="stylesheet" type="text/css" />
        <link href="assets/css/app.dark.css" rel="stylesheet" type="text/css" />
		<?php } ?>
    </head>
	    <script src="assets/js/sweetalert.min.js"></script>
		<style>	
		.fas.blink {
      animation: blink 3s steps(5, start) infinite;
      -webkit-animation: blink 2s steps(5, start) infinite;
    }
    @keyframes blink {
      to {
        visibility: hidden;
      }
    }
    @-webkit-keyframes blink {
      to {
        visibility: hidden;
      }
    }
	
#myBtn {
  display: none;
  position: fixed;
  bottom: 40px;
  right: 30px;
  z-index: 99;
  font-size: 18px;
  border: none;
  outline: none;
  background-color: #56C3D6;
  color: white;
  cursor: pointer;
  padding: 15px;
 		  border-radius: 5rem; <!--/*bouton  remonter*/-->
		  border-top-left-radius: 00;<!--/*bouton  corner haut a gauche*/-->
	      border-bottom-left-radius: 02;<!--/*bouton  corner bas a gauche*/-->
	      border-top-right-radius: 00;<!--/*bouton  corner haut a droite*/-->
	      border-bottom-right-radius: 02;<!--/*bouton  corner bas a droite*/-->
		  }

#myBtn:hover {
  background-color: #555;
}
	</style>
    <body>
        <!-- Navigation Bar-->
        <header id="topnav">
            <!-- Topbar Start -->
            <div class="navbar-custom">
                <div class="container-fluid">
                    <ul class="list-unstyled topnav-menu float-right mb-0">
                        <li class="dropdown notification-list">
                            <!-- Mobile menu toggle-->
                            <a class="navbar-toggle nav-link">
                                <div class="lines text-white">
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                </div>
                            </a>
                            <!-- End mobile menu toggle-->
                        </li>
						<?php if (($rServerError) && ($rPermissions["is_admin"]) && (hasPermissions("adv", "servers"))) { ?>
                        <!--<li class="notification-list">
                            <a href="./servers.php" class="nav-link right-bar-toggle waves-effect text-danger">
                                <i class="mdi mdi-alarm-light noti-icon"></i>
                            </a>
                        </li>-->
                        <?php } ?>
						<?php if ($rPermissions["is_reseller"]) { ?>
						<li class="dropdown notification-list">
                            <a class="nav-link dropdown-toggle nav-user mr-0 waves-effect text-white" data-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                                <i class="fas fa-user-alt"></i><b>&nbsp;&nbsp;<?=$_["welcome"]?>&nbsp;<?=$rUserInfo["username"]?></b> <i class="mdi mdi-chevron-down"></i>
                            </a>                               <!-------------welcome---------------->
							<div class="dropdown-menu profile-dropdown">
                                <a href="./edit_profile.php" class="dropdown-item notify-item"><span class="mdi mdi-account-circle"> <?=$_["user_profile"]?></span></a>
                                <a href="./logout.php" class="dropdown-item notify-item"><span class="mdi mdi-logout"> <?=$_["logout"]?></span></a>
                            </a>
                        </li>
						<?php } ?>
						<?php if ($rPermissions["is_admin"]) { ?>
						<li class="dropdown notification-list">
                            <a class="nav-link dropdown-toggle nav-user mr-0 waves-effect text-white" data-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                                <i class="fas fa-user-alt"></i><b>&nbsp;&nbsp;<?=$_["welcome"]?>&nbsp;<?=$rUserInfo["username"]?></b> <i class="mdi mdi-chevron-down"></i>
                            </a>                               <!-------------welcome---------------->
							<div class="dropdown-menu profile-dropdown">
								<?php if (hasPermissions("adv", "edit_profile")) { ?>
                                <a href="./edit_profile.php" class="dropdown-item notify-item"><span class="mdi mdi-account-circle"> <?=$_["user_profile"]?></span></a>
                                <?php }
								if (hasPermissions("adv", "manage_tickets")) { ?>
                                <a href="./tickets.php" class="dropdown-item notify-item"> <span class="mdi mdi-email"> <?=$_["tickets"]?></a>
								<div class="separator"></div>
                                <?php }
								if ((hasPermissions("adv", "settings")) OR (hasPermissions("adv", "database"))) { ?>
                                <a href="./settings.php" class="dropdown-item notify-item"><span class="mdi mdi-wrench mdi-rotate-90"> <?=$_["general_settings"]?></span></a>
								<?php }
								if ((hasPermissions("adv", "folder_watch_settings")) OR (hasPermissions("adv", "database"))) { ?>
                                <a href="./settings_watch.php" class="dropdown-item notify-item"><span class="mdi mdi-eye"> <?=$_["watch_settings"]?></span></a>
								<?php }
								if ((hasPermissions("adv", "settings")) OR (hasPermissions("adv", "database"))) { ?>
                                <a href="./backups.php" class="dropdown-item notify-item"><span class="mdi mdi-backup-restore"> <?=$_["backups"]?></span></a>
								<?php }
								if ((hasPermissions("adv", "settings")) OR (hasPermissions("adv", "database"))) { ?>
                                <a href="./db_sql.php" class="dropdown-item notify-item"><span class="mdi mdi-database"> <?=$_["database"]?></span></a>
								<div class="separator"></div>
								<?php }
								if (hasPermissions("adv", "login_flood")) { ?>
                                <a href="./logout.php" class="dropdown-item notify-item"><span class="mdi mdi-logout"> <?=$_["logout"]?></span></a>
                                <?php } ?>
                            </a>
                        </li>
						<?php } ?>
						<?php if (($rPermissions["is_admin"]) && ($rAdminSettings["show_tickets"])) {
							foreach ($rCheckTickets as $rCheckTicket) { ?>
							<?php if (($rCheckTicket["status"] == 1) AND ($rCheckTicket["admin_read"] == 0)) { ?>
							<li class="notification-list">
								<a href="./ticket_view.php?id=<?=$rCheckTicket["id"]?>" class="nav-link right-bar-toggle waves-effect text-info" role="button" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="<?=$_["new_ticket"]?> <?=strtolower($rCheckTicket["username"])?>">
							         <i class="fas fa-envelope blink noti-icon"></i>
								</a>
							</li>
						<?php } ?>
						<?php } } ?>								
                    </ul>
                    <!-- LOGO -->
                    <div class="logo-box">
                        <a href="<?php if ($rPermissions["is_admin"]) { ?>dashboard.php<?php } else { ?>reseller.php<?php } ?>" class="logo text-center">
                            <span class="logo-lg">
                                <img src="<?=$rSettings["logo_url"]?>" alt="" height="24">
                            </span>
                            <span class="logo-sm">
                                <img src="<?=$rSettings["logo_url"]?>" alt="" height="24">
                            </span>
                        </a>
                    </div>
                    <div class="clearfix"></div>
                </div> 
            </div>
            <!-- end Topbar -->
            <div class="topbar-menu">
                <div class="container-fluid">
                    <div id="navigation">
                        <!-- Navigation Menu-->
                        <ul class="navigation-menu">
						    <?php if (($rPermissions["is_reseller"]) && ($rPermissions["reseller_client_connection_logs"])) { ?>
                            <li class="has-submenu">
                                <a href="#"><i class="fe-activity text-danger"></i><?=$_["dashboard"]?> <div class="arrow-down"></div></a>
                                <ul class="submenu">
								    <li><a href="./<?php if ($rPermissions["is_admin"]) { ?>dashboard.php<?php } else { ?>reseller.php<?php } ?>" aria-expanded="false"><span class="fe-activity"></span> <?=$_["dashboard"]?></a></li><br>
                                    <li><a href="./live_connections.php"><span class="mdi mdi-account-network"> <?=$_["live_connections"]?></span></a></li><br>
                                    <li><a href="./user_activity.php"><span class="mdi mdi-file-document"> <?=$_["activity_logs"]?></span></a></li>
                                </ul>
                            </li>
							<?php } 
						    if ($rPermissions["is_admin"]) {
							if ((hasPermissions("adv", "live_connections")) OR (hasPermissions("adv", "connection_logs"))) { ?>
                            <li class="has-submenu">
                                <a href="#"><i class="fe-activity text-danger"></i><?=$_["dashboard"]?> <div class="arrow-down"></div></a>
                                <ul class="submenu">
								    <li><a href="./<?php if ($rPermissions["is_admin"]) { ?>dashboard.php<?php } else { ?>reseller.php<?php } ?>" aria-expanded="false"><span class="fe-activity"></span> <?=$_["dashboard"]?></a></li><br>
                                    <?php if (hasPermissions("adv", "live_connections")) { ?>
                                    <li><a href="./live_connections.php"><span class="mdi mdi-account-network"> <?=$_["live_connections"]?></span></a></li><br>
									<?php }
									if (hasPermissions("adv", "live_connections")) { ?>
                                    <li><a href="./user_activity.php"><span class="mdi mdi-file-document"> <?=$_["activity_logs"]?></span></a></li><br>
									<?php }
                                    if (hasPermissions("adv", "process_monitor")) { ?>
                                    <li><a href="./process_monitor.php?server=<?=$_INFO["server_id"]?>"><span class="mdi mdi-chart-line"> <?=$_["process_monitor"]?></span></a></li>
									<?php } ?>
                                </ul>
                            </li>
						    <?php } }
                            if ($rPermissions["is_admin"]) {
							if ((hasPermissions("adv", "servers")) OR (hasPermissions("adv", "add_server")) OR (hasPermissions("adv", "live_connections")) OR (hasPermissions("adv", "stream_tools")) OR (hasPermissions("adv", "connection_logs"))) { ?>
                            <li class="has-submenu">
                                <a href="#"><i class="fas fa-server"></i><?=$_["servers"]?> <div class="arrow-down"></div></a>
                                <ul class="submenu">
                                    <?php if (hasPermissions("adv", "add_server")) { ?>
                                    <li><a href="./server.php"><span class="mdi mdi-upload-network"> <?=$_["add_existing_lb"]?></span></a></li><br>
                                    <li><a href="./install_server.php"><span class="mdi mdi-plus-network"> <?=$_["install_load_balancer"]?></span></a></li><br>
									<?php }
									if (hasPermissions("adv", "servers")) { ?>
                                    <li><a href="./servers.php"><span class="mdi mdi-server-network"> <?=$_["manage_servers"]?></span></a></li>
									<?php } ?>
                                </ul>
                            </li>
							<?php }
							if ((hasPermissions("adv", "add_user")) OR (hasPermissions("adv", "users")) OR (hasPermissions("adv", "mass_edit_users")) OR (hasPermissions("adv", "import_streams")) OR (hasPermissions("adv", "streams")) OR (hasPermissions("adv", "mass_edit_streams")) OR (hasPermissions("adv", "manage_events")) OR (hasPermissions("adv", "import_movies")) OR (hasPermissions("adv", "movies")) OR (hasPermissions("adv", "series")) OR (hasPermissions("adv", "radio")) OR (hasPermissions("adv", "mass_sedits_vod")) OR (hasPermissions("adv", "mass_sedits")) OR (hasPermissions("adv", "mass_edits_radio")) OR (hasPermissions("adv", "stream_tools")) OR (hasPermissions("adv", "fingerprint")) OR (hasPermissions("adv", "mass_delete")) OR (hasPermissions("adv", "mng_regusers")) OR (hasPermissions("adv", "add_reguser")) OR (hasPermissions("adv", "credits_log")) OR (hasPermissions("adv", "panel_errors"))  OR (hasPermissions("adv", "client_request_log")) OR (hasPermissions("adv", "reg_userlog"))OR (hasPermissions("adv", "live_connections")) OR (hasPermissions("adv", "connection_logs")) OR (hasPermissions("adv", "stream_errors")) OR (hasPermissions("adv", "manage_events")) OR (hasPermissions("adv", "settings")) OR (hasPermissions("adv", "database")) OR (hasPermissions("adv", "block_ips")) OR (hasPermissions("adv", "block_isps")) OR (hasPermissions("adv", "block_uas")) OR (hasPermissions("adv", "categories")) OR (hasPermissions("adv", "channel_order")) OR (hasPermissions("adv", "epg")) OR (hasPermissions("adv", "folder_watch")) OR (hasPermissions("adv", "mng_groups")) OR (hasPermissions("adv", "mng_packages")) OR (hasPermissions("adv", "process_monitor")) OR (hasPermissions("adv", "rtmp")) OR (hasPermissions("adv", "subresellers")) OR (hasPermissions("adv", "tprofiles"))) { ?>
							<li class="has-submenu">
							<a href="#"> <i class="fas fa-cog text-warning"></i><?=$_["management"]?> <div class="arrow-down"></div></a>
							<ul class="submenu">
								<li class="has-submenu">
                                <a href="#"> <i class="mdi mdi-plus"></i> <?=$_["service_setup"]?><div class="arrow-down"></div></a><br>
                                <ul class="submenu">
								    <?php if (hasPermissions("adv", "mng_packages")) { ?>
                                    <li><a href="./packages.php"><span class="mdi mdi-package"> <?=$_["packages"]?></span></a></li><br>
								    <?php }
								    if (hasPermissions("adv", "categories")) { ?>
                                    <li><a href="./stream_categories.php"><span class="mdi mdi-folder-open"> <?=$_["categories"]?></span></a></li><br>
							    	<?php }
								    if (hasPermissions("adv", "mng_groups")) { ?>
                                    <li><a href="./groups.php"><span class="mdi mdi-account-multiple"> <?=$_["groups"]?></span></a></li><br>
								    <?php }
								    if (hasPermissions("adv", "epg")) { ?>
                                    <li><a href="./epgs.php"><span class="mdi mdi-play-protected-content"> <?=$_["epgs"]?></span></a></li><br>
								    <?php }
								    if (hasPermissions("adv", "channel_order")) { ?>
                                    <li><a href="./channel_order.php"><span class="mdi mdi-reorder-horizontal"> <?=$_["channel_order"]?></span></a></li><br>
								    <?php }
								    if (hasPermissions("adv", "folder_watch")) { ?>
                                    <li><a href="./watch.php"><span class="mdi mdi-eye"> <?=$_["folder_watch"]?></span></a></li><br>
								    <?php }
								    if (hasPermissions("adv", "subresellers")) { ?>
                                    <li><a href="./subresellers.php"><span class="mdi mdi-account-multiple"> <?=$_["subresellers"]?></span></a></li><br>
								    <?php }
								    if (hasPermissions("adv", "tprofiles")) { ?>
                                    <li><a href="./profiles.php"><span class="mdi mdi-find-replace"> <?=$_["transcode_profiles"]?></span></a></li><br>
									<?php }
									if (hasPermissions("adv", "live_connections")) { ?>
								    <li><a href="./line_connections.php"><span class="mdi mdi-playlist-check"> <?=$_["provider_con_check"]?></span></a></li>
									<?php } ?>
                                </ul>
                            </li>
							<li class="has-submenu">
                                <a href="#"> <i class="mdi mdi-plus"></i> <?=$_["security"]?><div class="arrow-down"></div></a><br>
                                <ul class="submenu">
								    <?php if (hasPermissions("adv", "login_flood")) { ?>
                                    <li><a href="./flood_login.php"><span class="mdi mdi-account-alert"> <?=$_["logins_flood"]?></span></a></li><br>
                                    <?php }
								    if (hasPermissions("adv", "security_center")) { ?>
                                    <li><a href="./security_center.php"><span class="mdi mdi-security"> <?=$_["security_center"]?></span></a></li><br>
								    <?php }
								    if (hasPermissions("adv", "block_ips")) { ?>
                                    <li><a href="./ips.php"><span class="mdi mdi-close-octagon"> <?=$_["blocked_ips"]?></span></a></li><br>
								    <?php }
                                    if (hasPermissions("adv", "block_isps")) { ?>
                                    <li><a href="./isps.php"><span class="mdi mdi-close-network"> <?=$_["blocked_isps"]?></span></a></li><br>
                                    <?php }
								    if (hasPermissions("adv", "rtmp")) { ?>
                                    <li><a href="./rtmp_ips.php"><span class="mdi mdi-close"> <?=$_["rtmp_ips"]?></span></a></li><br>
								    <?php }
								    if (hasPermissions("adv", "block_uas")) { ?>
                                    <li><a href="./useragents.php"><span class="mdi mdi-close-box"> <?=$_["blocked_uas"]?></span></a></li>
								    <?php } ?> 
                                </ul>
                            </li>
							<li class="has-submenu">
                                <a href="#"> <i class="mdi mdi-plus"></i> <?=$_["tools"]?><div class="arrow-down"></div></a><br>
                                <ul class="submenu">
								    <?php if (hasPermissions("adv", "mass_delete")) { ?>
                                    <li><a href="./mass_delete.php"><span class="mdi mdi-delete"> <?=$_["mass_delete"]?></span></a></li><br>
									<?php }
									if (hasPermissions("adv", "fingerprint")) { ?>
                                    <li><a href="./fingerprint.php"><span class="mdi mdi-fingerprint"> <?=$_["fingerprint"]?></span></a></li><br>
									<?php }
									if (hasPermissions("adv", "stream_tools")) { ?>
									<li><a href="./stream_tools.php"><span class="mdi mdi-wrench mdi-rotate-90"> <?=$_["stream_tools"]?></span></a></li><br>
									<li><a href="./ip_change.php"><span class="mdi mdi-ip"> <?=$_["ip_change"]?></span></a></li> <br>
									<li><a href="./couvers_change.php"><span class="mdi mdi-file-image"> <?=$_["dns_covers_change"]?></span></a></li><br>
									<li><a href="./log_tools.php"><span class="mdi mdi-cube"> <?=$_["quick_tools"]?></span></a></li>
									<?php } ?>
                                </ul>
                            </li>
							<li class="has-submenu">
                                <a href="#"> <i class="mdi mdi-plus"></i> <?=$_["logs"]?><div class="arrow-down"></div></a>
                                <ul class="submenu">
								    <?php if (hasPermissions("adv", "reg_userlog")) { ?>
                                    <li><a href="./reg_user_logs.php"><span class="mdi mdi-account-details"> <?=$_["reseller_logs"]?></span></a></li><br>
                                    <?php }
									if (hasPermissions("adv", "credits_log")) { ?>
                                    <li><a href="./credit_logs.php"><span class="mdi mdi-credit-card-multiple"> <?=$_["credit_logs"]?></span></a></li><br>
									<?php }
									if (hasPermissions("adv", "login_logs")) { ?>
                                    <li><a href="./login_logs.php"><span class="mdi mdi-file-document"> <?=$_["login_logs"]?></span></a></li><br>
									<?php }
									if (hasPermissions("adv", "client_request_log")) { ?>
                                    <li><a href="./client_logs.php"><span class="mdi mdi-account-search"> <?=$_["client_logs"]?></span></a></li><br>
									<?php }
									if (hasPermissions("adv", "stream_errors")) { ?>
                                    <li><a href="./stream_logs.php"><span class="mdi mdi-file-document"> <?=$_["stream_logs"]?></span></a></li><br>
									<?php }
									if (hasPermissions("adv", "connection_logs")) { ?>
                                    <li><a href="./user_ips.php"><span class="mdi mdi-ip"> <?=$_["line_ip_usage"]?></span></a></li><br>
									<?php }
									if (hasPermissions("adv", "panel_errors")) { ?>
                                    <li><a href="./panel_logs.php"><span class="mdi mdi-file-document"> <?=$_["panel_logs"]?></span></a></li><br>
									<?php } 
									if (hasPermissions("adv", "manage_events")) { ?>
                                    <li><a href="./mag_events.php"><span class="mdi mdi-message"> <?=$_["mag_event_logs"]?></span></a></li><br>
									<?php } 
									if (hasPermissions("adv", "mag_claims")) { ?>
                                    <li><a href="./mag_claims.php"><span class="mdi mdi-message"> <?=$_["mag_claims"]?></span></a></li>
									<?php } ?>
                                </ul>
                            </li>
							</ul>
							</li>
							<?php }
							if ((hasPermissions("adv", "add_user")) OR (hasPermissions("adv", "users")) OR (hasPermissions("adv", "mass_edit_users")) OR (hasPermissions("adv", "mng_regusers")) OR (hasPermissions("adv", "add_reguser")) OR (hasPermissions("adv", "credits_log")) OR (hasPermissions("adv", "client_request_log")) OR (hasPermissions("adv", "reg_userlog"))) { ?>
							<li class="has-submenu">
                                <a href="#"> <i class="fas fa-users text-primary"></i><?=$_["reg_users"]?> <div class="arrow-down"></div></a>
                                <ul class="submenu">
                                    <?php if (hasPermissions("adv", "add_reguser")) { ?>
                                    <li><a href="./reg_user.php"><span class="mdi mdi-account-multiple-plus"> <?=$_["add_registered_user"]?></span></a></li><br>
									<?php }
									if (hasPermissions("adv", "mng_regusers")) { ?>
                                    <li><a href="./reg_users.php"><span class="mdi mdi-account-multiple"> <?=$_["manage_registered_users"]?></span></a></li><br>
									<?php }
									if (hasPermissions("adv", "mng_regusers")) { ?>
                                    <li><a href="./reg_users_stats.php"><span class="mdi mdi-account-multiple"> <?=$_["reseller_statistics"]?></span></a></li>
									<?php } ?>
                                </ul>
                            </li>
                            <?php }
							if ((hasPermissions("adv", "add_user")) OR (hasPermissions("adv", "users")) OR (hasPermissions("adv", "mass_edit_users")) OR (hasPermissions("adv", "mng_regusers")) OR (hasPermissions("adv", "add_reguser")) OR (hasPermissions("adv", "credits_log")) OR (hasPermissions("adv", "client_request_log")) OR (hasPermissions("adv", "reg_userlog")) OR (hasPermissions("adv", "add_mag")) OR (hasPermissions("adv", "manage_mag")) OR (hasPermissions("adv", "add_e2")) OR (hasPermissions("adv", "manage_e2")) OR (hasPermissions("adv", "manage_events"))) { ?>
							<li class="has-submenu">
                                <a href="#"> <i class="fas fa-desktop text-pink"></i><?=$_["users"]?> <div class="arrow-down"></div></a>
                                <ul class="submenu">
								    <li class="has-submenu">
								        <a href="#"> <i class="mdi mdi-plus"></i> <?=$_["user_lines"]?><div class="arrow-down"></div></a>
								        <ul class="submenu">
                                            <?php if (hasPermissions("adv", "add_user")) { ?>
                                            <li><a href="./user.php"><span class="mdi mdi-account-plus"></span> <?=$_["add_user"]?></span></a></li><br>
									        <?php }
									        if (hasPermissions("adv", "users")) { ?>
                                            <li><a href="./users.php"><span class="mdi mdi-account-multiple"> <?=$_["manage_users"]?></span></a></li>
									        <?php } ?>
									    </ul>
								    </li>	
								<br>
								    <li class="has-submenu">
								        <a href="#"> <i class="mdi mdi-plus"></i> <?=$_["mag_devices"]?><div class="arrow-down"></div></a>
                                        <ul class="submenu">
									        <?php if (hasPermissions("adv", "add_mag")) { ?>
                                            <li><a href="./user.php?mag"><span class="mdi mdi-account-plus"> <?=$_["add_mag"]?></span></a></li><br>
                                            <!--<li><a href="./mag.php"><?=$_["link_mag"]?></a></li>-->
									        <?php }
									        if (hasPermissions("adv", "manage_mag")) { ?>
                                            <li><a href="./mags.php"><span class="mdi mdi-account-multiple"> <?=$_["manage_mag_devices"]?></span></a></li><br>
									        <?php }
									        if (hasPermissions("adv", "add_mag")) { ?>
									        <li><a href="./mag.php"><span class="mdi mdi-account-switch"> <?=$_["link_mag"]?></span></a></li>
									         <?php } ?>
									    </ul>
							     	</li>
								<br>
								    <li class="has-submenu">
								        <a href="#"> <i class="mdi mdi-plus"></i> <?=$_["enigma_devices"]?><div class="arrow-down"></div></a>
                                        <ul class="submenu">
                                            <?php if (hasPermissions("adv", "add_e2")) { ?>
                                            <li><a href="./user.php?e2"><span class="mdi mdi-account-plus"> <?=$_["add_enigma"]?></span></a></li><br>
                                            <!--<li><a href="./enigma.php"><?=$_["link_enigma"]?></a></li>-->
									        <?php }
									        if (hasPermissions("adv", "manage_e2")) { ?>
                                            <li><a href="./enigmas.php"><span class="mdi mdi-account-multiple"> <?=$_["manage_enigma_devices"]?></span></a></li><br>
									        <?php }
									        if (hasPermissions("adv", "add_e2")) { ?>
                                            <li><a href="./enigma.php"><span class="mdi mdi-account-switch"> <?=$_["link_enigma"]?></span></a></li>
									        <?php } ?>
                                        </ul>
                                    </li>	
								<br>
								    <li class="has-submenu">
									    <?php if (hasPermissions("adv", "mass_edit_users")) { ?>
								        <a href="./user_mass.php"> <i class="mdi mdi-account-edit"></i> <?=$_["mass_edit_users"]?></a>
                                        <?php } ?>
                                    </li>
								</ul>
							</li>	
							<?php }
							} else { ?>
							<li class="has-submenu">
                                <a href="#"> <i class="fas fa-desktop text-pink"></i><?=$_["users"]?> <div class="arrow-down"></div></a>
                                <ul class="submenu">
                                    <?php if ((!$rAdminSettings["disable_trial"]) && ($rPermissions["total_allowed_gen_trials"] > 0) && ($rUserInfo["credits"] >= $rPermissions["minimum_trial_credits"])) { ?>
                                    <li><a href="./user_reseller.php?trial"><span class="mdi mdi-account-plus"> <?=$_["generate_trial"]?></span></a></li><br>
                                    <?php } ?>
								<li class="has-submenu">
											<a href="#"> <i class="mdi mdi-plus mdi"></i> <?=$_["user_lines"]?><div class="arrow-down"></div></a><br>
											<ul class="submenu">
												<li><a href="./user_reseller.php"><span class="mdi mdi-account-plus"> <?=$_["add_user"]?></span></a></li><br>
                                                <li><a href="./users.php"><span class="mdi mdi-account-multiple"> <?=$_["manage_users"]?></span></a></li>
											</ul>
										</li> 
								<li class="has-submenu">
											<a href="#"> <i class="mdi mdi-plus mdi"></i> <?=$_["mag_devices"]?><div class="arrow-down"></div></a><br>
											<ul class="submenu">
												<li><a href="./user_reseller.php?mag"><span class="mdi mdi-account-plus"> <?=$_["add_mag"]?></span></a></li><br>
                                                <li><a href="./mags.php"><span class="mdi mdi-account-multiple"> <?=$_["manage_mag_devices"]?></span></a></li>
											</ul>
										</li> 
								<li class="has-submenu">
											<a href="#"> <i class="mdi mdi-plus mdi"></i> <?=$_["enigma_devices"]?><div class="arrow-down"></div></a>
											<ul class="submenu">
												<li><a href="./user_reseller.php?e2"><span class="mdi mdi-account-plus"></span> <?=$_["add_enigma"]?></a></li><br>
                                                <li><a href="./enigmas.php"><span class="mdi mdi-account-multiple"> <?=$_["manage_enigma_devices"]?></a></li>
											</ul>
										</li> 
									 
                                </ul>
							</li>	
							<?php }
                            if (($rPermissions["is_reseller"]) && ($rPermissions["create_sub_resellers"])) { ?>
                            <li class="has-submenu">
                                <a href="#"> <i class="fas fa-users text-primary"></i><?=$_["reg_users"]?> <div class="arrow-down"></div></a>
                                <ul class="submenu">
                                    <?php if ($rPermissions["is_admin"]) { ?>
                                    <li><a href="./reg_user.php"><span class="mdi mdi-account-multiple-plus"> <?=$_["add_subreseller"]?></span></a></li><br>
                                    <?php } else { ?>
                                    <li><a href="./subreseller.php"><span class="mdi mdi-account-multiple-plus"> <?=$_["add_subreseller"]?></span></a></li><br>
                                    <?php } ?>
                                    <li><a href="./reg_users.php"><span class="mdi mdi-account-multiple"> <?=$_["manage_subresellers"]?></span></a></li>
                                </ul>
                            </li>
                            <?php }
							if ($rPermissions["is_admin"]) {
							if ((hasPermissions("adv", "add_movie")) OR (hasPermissions("adv", "import_movies")) OR (hasPermissions("adv", "movies")) OR (hasPermissions("adv", "series")) OR (hasPermissions("adv", "add_series")) OR (hasPermissions("adv", "radio")) OR (hasPermissions("adv", "add_radio")) OR (hasPermissions("adv", "mass_sedits_vod")) OR (hasPermissions("adv", "mass_sedits")) OR (hasPermissions("adv", "mass_edits_radio")) OR (hasPermissions("adv", "add_stream")) OR (hasPermissions("adv", "import_streams")) OR (hasPermissions("adv", "create_channel")) OR (hasPermissions("adv", "streams")) OR (hasPermissions("adv", "mass_edit_streams"))  OR (hasPermissions("adv", "stream_tools"))  OR (hasPermissions("adv", "stream_errors"))  OR (hasPermissions("adv", "fingerprint"))) { ?>
                            <li class="has-submenu">
                                <a href="#"> <i class="fas fa-play text-info"></i><?=$_["content"]?> <div class="arrow-down"></div></a>
								<ul class="submenu">
									<li class="has-submenu">  
										<a href="#"> <i class="mdi mdi-plus"></i> <?=$_["streams"]?><div class="arrow-down"></div></a><br>	
										<ul class="submenu">
											<?php if (hasPermissions("adv", "add_stream")) { ?>
											<li><a href="./stream.php"><span class="mdi mdi-plus"> <?=$_["add_stream"]?></span></a></li><br>
											<?php }
											if (hasPermissions("adv", "streams")) { ?>
											<li><a href="./streams.php"><span class="mdi mdi-play-circle-outline"> <?=$_["manage_streams"]?></span></a></li><br>
											<?php }
											if (hasPermissions("adv", "mass_edit_streams")) { ?>
                                            <li><a href="./stream_mass.php"><span class="mdi mdi-border-color"> <?=$_["mass_edit_streams"]?></span></a></li><br> 
									        <?php }
											if (hasPermissions("adv", "import_streams")) { ?>
											<li><a href="./stream.php?import"><span class="mdi mdi-file-plus"> <?=$_["import_streams"]?></span></a></li><br>
											<?php }
											if (hasPermissions("adv", "streams")) { ?>
											<li><a href="./stream_stats.php"><span class="mdi mdi-chart-bar-stacked"> <?=$_["streams_statistics"]?></span></a></li>
											<?php } ?>
										</ul>
									</li> 
									<li class="has-submenu">
										<a href="#"> <i class="mdi mdi-plus"></i> <?=$_["created_channels"]?><div class="arrow-down"></div></a><br>
										<ul class="submenu">
											<?php if (hasPermissions("adv", "create_channel")) { ?>
                                            <li><a href="./created_channel.php"><span class="mdi mdi-plus"> <?=$_["create_channel"]?></span></a></li><br>
									        <?php } ?>
											<li><a href="./streams.php?filter=8"><span class="mdi mdi-play-circle-outline"> <?=$_["manage_channels"]?></span></a></li>
										</ul>
									</li> 
									<li class="has-submenu">  
										<a href="#"> <i class="mdi mdi-plus"></i> <?=$_["movies"]?><div class="arrow-down"></div></a><br>	
										<ul class="submenu">
											<?php if (hasPermissions("adv", "add_movie")) { ?>
                                            <li><a href="./movie.php"><span class="mdi mdi-plus"> <?=$_["add_movie"]?></span></a></li><br>
											<?php }
											if (hasPermissions("adv", "movies")) { ?>
                                            <li><a href="./movies.php"><span class="mdi mdi-movie"> <?=$_["manage_movies"]?></span></a></li><br>
											<?php }
											if (hasPermissions("adv", "mass_sedits_vod")) { ?>
                                            <li><a href="./movie_mass.php"><span class="mdi mdi-border-color"> <?=$_["mass_edit_movies"]?></span></a></li><br>
									        <?php }
											if (hasPermissions("adv", "import_movies")) { ?>
                                            <li><a href="./movie.php?import"><span class="mdi mdi-file-plus"> <?=$_["import_movies"]?></span></a></li><br>
									        <?php }
											if (hasPermissions("adv", "import_movies")) { ?>
                                            <li><a href="./vod_import.php"><span class="mdi mdi-file-plus"> <?=$_["import_movies_m3u"]?></span></a></li><br>
											<?php }
											if (hasPermissions("adv", "movies")) { ?>
                                            <li><a href="./duplicate_movies.php"><span class="mdi mdi-folder-search-outline"> <?=$_["duplicate_movies"]?></span></a></li><br>
											<?php }
											if (hasPermissions("adv", "movies")) { ?>
                                            <li><a href="./movie_stats.php"><span class="mdi mdi-chart-bar-stacked"> <?=$_["movies_statistics"]?></span></a></li>
									        <?php } ?>
										</ul>
									</li> 
									<li class="has-submenu">  
										<a href="#"> <i class="mdi mdi-plus"></i> <?=$_["series"]?><div class="arrow-down"></div></a><br>	
										<ul class="submenu">
											<?php if (hasPermissions("adv", "add_series")) { ?>
                                            <li><a href="./serie.php"><span class="mdi mdi-plus"> <?=$_["add_series"]?></span></a></li><br>
											<?php }
											if (hasPermissions("adv", "series")) { ?>
                                            <li><a href="./series.php"><span class="mdi mdi-youtube-tv"> <?=$_["manage_series"]?></span></a></li><br>
											<?php }
											if (hasPermissions("adv", "episodes")) { ?>
                                            <li><a href="./episodes.php"><span class="mdi mdi-youtube-tv"> <?=$_["manage_episodes"]?></span></a></li><br>
											<?php }
											if (hasPermissions("adv", "mass_sedits")) { ?>
                                            <li><a href="./series_mass.php"><span class="mdi mdi-border-color"> <?=$_["mass_edit_series"]?></span></a></li><br>
                                            <li><a href="./episodes_mass.php"><span class="mdi mdi-border-color"> <?=$_["mass_edit_episodes"]?></span></a></li><br>
									        <?php }
											if (hasPermissions("adv", "add_series")) { ?>
                                            <li><a href="./episode_import.php"><span class="mdi mdi-file-plus"> <?=$_["import_episodes_m3u"]?></span></a></li><br>
											<?php }
											if (hasPermissions("adv", "series")) { ?>
                                            <li><a href="./serie_stats.php"><span class="mdi mdi-chart-bar-stacked"> <?=$_["series_statistics"]?></span></a></li>
											<?php } ?>
										</ul>
									</li> 
									<li class="has-submenu">  
										<a href="#"> <i class="mdi mdi-plus"></i> <?=$_["stations"]?><div class="arrow-down"></div></a>	
										<ul class="submenu">
											<?php if (hasPermissions("adv", "add_radio")) { ?>
                                            <li><a href="./radio.php"><span class="mdi mdi-plus"> <?=$_["add_station"]?></span></a></li><br>
											<?php }
											if (hasPermissions("adv", "radio")) { ?>
                                            <li><a href="./radios.php"><span class="mdi mdi-radio"> <?=$_["manage_stations"]?></span></a></li><br>
											<?php }
                                            if (hasPermissions("adv", "mass_edit_radio")) { ?>
                                            <li><a href="./radio_mass.php"><span class="mdi mdi-border-color"> <?=$_["mass_edit_stations"]?></span></a></li>
									        <?php }	?>
										</ul>
									</li> 
                                </ul>
                            </li>
							<?php }
							if ((hasPermissions("adv", "add_bouquet")) OR (hasPermissions("adv", "bouquets"))) { ?>
                            <li class="has-submenu">
                                <a href="#"> <i class="fas fa-spa text-success"></i><?=$_["bouquets"]?> <div class="arrow-down"></div></a>
                                <ul class="submenu">
									<?php if (hasPermissions("adv", "add_bouquet")) { ?>
                                    <li><a href="./bouquet.php"><span class="mdi mdi-plus"> <?=$_["add_bouquet"]?></span></a></li><br>
									<?php }
									if (hasPermissions("adv", "bouquets")) { ?>
                                    <li><a href="./bouquets.php"><span class="mdi mdi-flower-tulip"> <?=$_["manage_bouquets"]?></span></a></li><br>
                                    <?php }
									if (hasPermissions("adv", "edit_bouquet")) { ?>
                                    <li><a href="./bouquet_sort.php"><span class="mdi mdi-reorder-horizontal"> <?=$_["order_bouquets"]?></span></a></li>
									<?php } ?>
                                </ul>
                            </li>
                            <?php }
							}
                            if (($rPermissions["is_reseller"]) && ($rPermissions["reset_stb_data"])) { ?>
                            <li class="has-submenu">
                                <a href="#"> <i class="fas fa-play text-info"></i><?=$_["content"]?> <div class="arrow-down"></div></a>
                                <ul class="submenu">
                                    <li><a href="./streams.php"><?=$_["streams"]?></a></li><br>
                                    <li><a href="./movies.php"><?=$_["movies"]?></a></li><br>
                                    <li><a href="./series.php"><?=$_["series"]?></a></li><br>
                                    <li><a href="./episodes.php"><?=$_["episodes"]?></a></li><br>
                                    <li><a href="./radios.php"><?=$_["stations"]?></a></li>
                                </ul>
                            </li>
                            
							<?php }
                            if ($rPermissions["is_reseller"]) { ?>
                            <li class="has-submenu">
                                <a href="#"> <i class="fas fa-envelope text-info"></i><?=$_["support"]?> <div class="arrow-down"></div></a>
                                <ul class="submenu">
                                    <li><a href="./ticket.php"><span class="mdi mdi-message-text"> <?=$_["create_ticket"]?></span></a></li><br>
                                    <li><a href="./tickets.php"><span class="mdi mdi-message-settings-variant"> <?=$_["manage_tickets"]?></span></a></li><br>
									<?php if ($rPermissions["allow_import"]) { ?>
                                    <li><a href="./resellersmarters.php"><span class="mdi mdi-message-settings-variant"> <?=$_["reseller_api_key"]?></span></a></li>
									<?php } ?>
                                </ul>
                            </li>
							<?php }
							if (($rPermissions["is_reseller"]) && ($rAdminSettings["active_apps"])) { ?>
							<li class="has-submenu">
                                <a href="#"> <i class="fas fa-qrcode text-success"></i><?=$_["iptv_apps"]?> <div class="arrow-down"></div></a>
                                <ul class="submenu">
                                    <li><a href="https://edit.duplexplay.com/" target="_blank"><span class="mdi mdi-account-star"> <?=$_["duplex_iptv"]?></a></li><br>
                                    <li><a href="https://www.netiptv.eu/upload" target="_blank"><span class="mdi mdi-account-star"> <?=$_["net_iptv"]?></a></li><br>
									<li><a href="http://siptv.eu/mylist/" target="_blank"><span class="mdi mdi-account-star"> <?=$_["smart_iptv"]?></a></li><br>
									<li><a href="https://iptvextreme.eu" target="_blank"><span class="mdi mdi-account-star"> <?=$_["iptv_extreme"]?></a></li><br>
									<li><a href="https://nanomid.com/player/add-playlist" target="_blank"><span class="mdi mdi-account-star"> <?=$_["nanomid"]?></a></li><br>
									<li><a href="https://mega-iptv-a2636.web.app/" target="_blank"><span class="mdi mdi-account-star"> <?=$_["mega_iptv"]?></a></li><br>
									<li><a href="https://ss-iptv.com/en/users/playlist" target="_blank"><span class="mdi mdi-account-star"> <?=$_["ss_iptv"]?></a></li>
                                </ul>
                            </li>
							<?php }
                            if (($rPermissions["is_admin"]) && (hasPermissions("adv", "manage_tickets"))) { ?>
							<li class="has-submenu">
                                <a href="#"> <i class="fas fa-qrcode text-purple"></i><?=$_["iptv_apps"]?> <div class="arrow-down"></div></a>
                                <ul class="submenu">
                                    <li><a href="https://edit.duplexplay.com/" target="_blank"><span class="mdi mdi-account-star"> <?=$_["duplex_iptv"]?></a></li><br>
                                    <li><a href="https://www.netiptv.eu/upload" target="_blank"><span class="mdi mdi-account-star"> <?=$_["net_iptv"]?></a></li><br>
									<li><a href="http://siptv.eu/mylist/" target="_blank"><span class="mdi mdi-account-star"> <?=$_["smart_iptv"]?></a></li><br>
									<li><a href="https://iptvextreme.eu" target="_blank"><span class="mdi mdi-account-star"> <?=$_["iptv_extreme"]?></a></li><br>
									<li><a href="https://nanomid.com/player/add-playlist" target="_blank"><span class="mdi mdi-account-star"> <?=$_["nanomid"]?></a></li><br>
									<li><a href="https://mega-iptv-a2636.web.app/" target="_blank"><span class="mdi mdi-account-star"> <?=$_["mega_iptv"]?></a></li><br>
									<li><a href="https://ss-iptv.com/en/users/playlist" target="_blank"><span class="mdi mdi-account-star"> <?=$_["ss_iptv"]?></a></li>
                                </ul>
                            </li>
                            <?php } 
							if (($rPermissions["is_reseller"]) && ($rAdminSettings["active_mannuals"])) { ?>
                            <li>
                                <a href="./reseller_mannuals.php"> <i class="fas fa-folder-open text-purple"></i><?=$_["mannuals"]?></a>
                            </li>
                            <?php } ?>
                        </ul>
                        <!-- End navigation menu -->
                        <div class="clearfix"></div>
                    </div>
                    <!-- end #navigation -->
                </div>
                <!-- end container -->
            </div>
            <!-- end navbar-custom -->
        </header>
        <!-- End Navigation Bar-->
		
<button onclick="topFunction()" id="myBtn" title="<?=$_["go_to_top"]?>"><i class="mdi mdi-arrow-up-thick"></i></button>
		
<script>
//Get the button
var mybutton = document.getElementById("myBtn");

// When the user scrolls down 20px from the top of the document, show the button
window.onscroll = function() {scrollFunction()};

function scrollFunction() {
  if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
    mybutton.style.display = "block";
  } else {
    mybutton.style.display = "none";
  }
}

// When the user clicks on the button, scroll to the top of the document
function topFunction() {
  document.body.scrollTop = 0;
  document.documentElement.scrollTop = 0;
}
</script>