<?php
include "session.php"; include "functions.php";
if (!$rPermissions["is_admin"]) { exit; }
if ((!hasPermissions("adv", "settings")) && (!hasPermissions("adv", "database"))) { exit; }

if ((isset($_POST["submit_settings"])) && (hasPermissions("adv", "settings"))) {
    $rArray = getSettings();
    foreach (Array("") as $rSetting) {
        if (isset($_POST[$rSetting])) {
            $rArray[$rSetting] = 1;
            unset($_POST[$rSetting]);
        } else {
            $rArray[$rSetting] = 0;
        }
    }
    if (isset($_POST["automatic_backups"])) {
        $rAdminSettings["automatic_backups"] = $_POST["automatic_backups"];
        unset($_POST["automatic_backups"]);
    }
    if (isset($_POST["backups_to_keep"])) {
        $rAdminSettings["backups_to_keep"] = $_POST["backups_to_keep"];
        unset($_POST["backups_to_keep"]);
    }
	if (isset($_POST["automatic_backups_gdrive"])) {
        $rAdminSettings["automatic_backups_gdrive"] = true;
        unset($_POST["automatic_backups_gdrive"]);
    } else {
        $rAdminSettings["automatic_backups_gdrive"] = false;
    }
    if (isset($_POST["gdrive_client_id"])) {
        $rAdminSettings["gdrive_client_id"] = $_POST["gdrive_client_id"];
        unset($_POST["gdrive_client_id"]);
    }
    if (isset($_POST["gdrive_client_secret"])) {
        $rAdminSettings["gdrive_client_secret"] = $_POST["gdrive_client_secret"];
        unset($_POST["gdrive_client_secret"]);
    }
    if (isset($_POST["gdrive_refresh_token"])) {
        $rAdminSettings["gdrive_refresh_token"] = $_POST["gdrive_refresh_token"];
        unset($_POST["gdrive_refresh_token"]);
    }
    
    writeAdminSettings();
    foreach($_POST as $rKey => $rValue) {
        if (isset($rArray[$rKey])) {
            $rArray[$rKey] = $rValue;
        }
    }
    $rValues = Array();
    foreach ($rArray as $rKey => $rValue) {
        if (is_array($rValue)) {
            $rValue = json_encode($rValue);
        }
        if (is_null($rValue)) {
            $rValues[] = '`'.ESC($rKey).'` = NULL';
        } else {
            $rValues[] = '`'.ESC($rKey).'` = \''.ESC($rValue).'\'';
        }
    }
    $rQuery = "UPDATE `settings` SET ".join(", ", $rValues).";";
    if ($db->query($rQuery)) {
        $_STATUS = 0;
    } else {
        $_STATUS = 1;
    }
}

$rSettings = getSettings(); // Update
$rSettings["sidebar"] = $rUserInfo["sidebar"];

if ($rSettings["sidebar"]) {
    include "header_sidebar.php";
} else {
    include "header.php";
}
        if ($rSettings["sidebar"]) { ?>
        <div class="content-page"><div class="content boxed-layout-ext"><div class="container-fluid">
        <?php } else { ?>
        <div class="wrapper boxed-layout-ext"><div class="container-fluid">
        <?php } ?>
                <form action="./backups.php" method="POST" id="category_form">
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <h4 class="page-title"><?=$_["backups"]?></h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 
                    <div class="row">
                        <div class="col-xl-12">
                            
                            <div class="card">
                                <div class="card-body">
                                    <div id="basicwizard">
                                        <ul class="nav nav-pills bg-light nav-justified form-wizard-header mb-4">
										<?php if (hasPermissions("adv", "database")) { ?>
                                            <li class="nav-item">
										        <a href="#backups" data-toggle="tab" class="nav-link rounded-0 pt-2 pb-2">
											    <i class="mdi mdi-backup-restore mr-1"></i>
											    <span class="d-none d-sm-inline"><?=$_["backups"]?></span>
										        </a>
									        </li>
										<?php } ?>
                                        </ul>
                                        <div class="tab-content b-0 mb-0 pt-0">
										<?php if (hasPermissions("adv", "database")) { ?>
											<div class="tab-content b-0 mb-0 pt-0">
									            <div class="tab-pane" id="backups">
										            <div class="row">
                                                        <div class="col-12">
                                                        <div class="form-group row mb-4">
                                                            <label class="col-md-4 col-form-label" for="automatic_backups"><?=$_["automatic_backups"]?></label>
                                                            <div class="col-md-2">
                                                                <select name="automatic_backups" id="automatic_backups" class="form-control" data-toggle="select2">
                                                                    <option<?php if ($rAdminSettings["automatic_backups"] == "off") { echo " selected"; } ?> value="off"><?=$_["off"]?></option>
                                                                    <option<?php if ($rAdminSettings["automatic_backups"] == "hourly") { echo " selected"; } ?> value="hourly"><?=$_["hourly"]?></option>
                                                                    <option<?php if ($rAdminSettings["automatic_backups"] == "daily") { echo " selected"; } ?> value="daily"><?=$_["daily"]?></option>
                                                                    <option<?php if ($rAdminSettings["automatic_backups"] == "weekly") { echo " selected"; } ?> value="weekly"><?=$_["weekly"]?></option>
                                                                    <option<?php if ($rAdminSettings["automatic_backups"] == "monthly") { echo " selected"; } ?> value="monthly"><?=$_["monthly"]?></option>
                                                                </select>
                                                            </div>
                                                                <label class="col-md-4 col-form-label" for="backups_to_keep"><?=$_["backups_to_keep"]?> <i data-toggle="tooltip" data-placement="top" title="" data-original-title="<?=$_["enter_for_unlimited"]?>" class="mdi mdi-information"></i></label>
                                                                <div class="col-md-2">
                                                                    <input type="text" class="form-control" id="backups_to_keep" name="backups_to_keep" value="<?=htmlspecialchars($rAdminSettings["backups_to_keep"] ? $rAdminSettings["backups_to_keep"] : 0)?>">
                                                                </div>
                                                            </div>
															<div class="form-group row mb-4">
															    <label class="col-md-4 col-form-label" for="automatic_backups_gdrive"><?=$_["automatic_backups_gdrive"]?> </label>
																<div class="col-md-2">
                                                                    <input name="automatic_backups_gdrive" id="automatic_backups_gdrive" type="checkbox"<?php if ($rAdminSettings["automatic_backups_gdrive"] == 1) { echo "checked "; } ?>data-plugin="switchery" class="js-switch" data-color="#039cfd"/>
                                                                 </div>
															</div>
															<div class="form-group row mb-4">
															    <label class="col-md-4 col-form-label" for="gdrive_client_id"><?=$_["gdrive_client_id"]?> <i data-toggle="tooltip" data-placement="top" title="" data-original-title="<?=$_["gdrive_client_id_info"]?>" class="mdi mdi-information"></i></label>
																<div class="col-md-8">
																    <input type="text" class="form-control" id="gdrive_client_id" name="gdrive_client_id" value="<?=htmlspecialchars($rAdminSettings["gdrive_client_id"] ? $rAdminSettings["gdrive_client_id"] : "")?>">
                                                                </div>
															</div>
															<div class="form-group row mb-4">
															    <label class="col-md-4 col-form-label" for="gdrive_client_secret"><?=$_["gdrive_client_secret"]?> <i data-toggle="tooltip" data-placement="top" title=""     data-original-title="<?=$_["gdrive_client_secret_info"]?>" class="mdi mdi-information"></i></label>                                                           
																<div class="col-md-8">
																    <input type="text" class="form-control" id="gdrive_client_secret" name="gdrive_client_secret" value="<?=htmlspecialchars($rAdminSettings["gdrive_client_secret"] ? $rAdminSettings["gdrive_client_secret"] : "")?>">                                                           
																</div>
															</div>
															<div class="form-group row mb-4">
															    <label class="col-md-4 col-form-label" for="gdrive_refresh_token"><?=$_["gdrive_refresh_token"]?> <i data-toggle="tooltip" data-placement="top" title="" data-original-title="<?=$_["gdrive_refresh_token_info"]?>" class="mdi mdi-information"></i></label>
																<div class="col-md-8">
																    <input type="text" class="form-control" id="gdrive_refresh_token" name="gdrive_refresh_token" value="<?=htmlspecialchars($rAdminSettings["gdrive_refresh_token"] ? $rAdminSettings["gdrive_refresh_token"] : "")?>">
																</div>
															</div>
															<div class="form-group row mb-4">
															     <label class="col-md-4 col-form-label"> <a href="#" data-toggle="modal" data-target="#HowToModal">(<?=$_["how_to_text"]?>)</a><br>   <a href="https://www.youtube.com/watch?v=FAM_4J7ywcE" target="_blank">(<?=$_["how_to_youtube"]?>)</a></label></br>
															</div>
                                                            <table class="table table-borderless mb-0" id="datatable-backups">
                                                                <thead class="thead-light">
                                                                    <tr>
                                                                        <th class="text-center"><?=$_["date"]?></th>
                                                                        <th class="text-center"><?=$_["filename"]?></th>
																	    <th class="text-center"><?=$_["filesize"]?></th>
                                                                        <th class="text-center"><?=$_["actions"]?></th>
                                                                    </tr>
                                                                </thead>
                                                            <tbody></tbody>
                                                            </table>
                                                        </div> <!-- end col -->
                                                    </div>
										            <ul class="list-inline wizard mb-0" style="margin-top:30px;">
                                                        <li class="list-inline-item float-right">
                                                            <button id="create_backup" onClick="api('', 'backup')" class="btn btn-info"><?=$_["create_backup_now"]?></button>
                                                            <input name="submit_settings" type="submit" class="btn btn-primary" value="<?=$_["save_changes"]?>" />
                                                        </li>
                                                    </ul>
									            </div>
								            </div>
											
											<div class="modal fade" id="HowToModal" tabindex="-1" role="dialog" aria-labelledby="HowToModalTitle" aria-hidden="true">
											    <div class="modal-dialog" role="document">
												    <div class="modal-content">
													    <div class="modal-header">
														    <h5 class="modal-title" id="exampleModalLongTitle"><?=$_["how_to_setup_google_drive"]?></h5>
															<button type="button" class="close" data-dismiss="modal" aria-label="<?=$_["close"]?>"><span aria-hidden="true">&times;</span></button>
														</div>
														<div class="modal-body">
														    <div class="col-12">
														    <h1><?=$_["get_api_credentials"]?></h1>
															<p><?=$_["the_first_step_is_to_get_our_google_drive_credentials_which_too_are"]?></p>
															    <ul>
																    <li><?=$_["a_client_id_and_a_client_cecret"]?></li>
																	<li><?=$_["a_redirect_uri_and_refresh_token"]?></li>
																</ul>
																<p><?=$_["you_need_to_have_a_google_account_for_the_steps_below"]?></p>
															    <ol>
																    <li><?=$_["go_to"]?> <a href="https://console.cloud.google.com/cloud-resource-manager"  target="_blank">https://console.cloud.google.com/cloud-resource-manager</a> <?=$_["and_click_on_the_button"]?> <strong>"<?=$_["create_project"]?>"</strong><?=$_["give_a_name_to_the_project"]?> <strong>"<?=$_["create"]?>"</strong> <?=$_["to_submit_and_when_for_the_creation"]?></li>
																	<br>
																	<li><?=$_["once_the_project_is_created"]?> <strong>"<?=$_["api&services"]?>"</strong> <?=$_["locate_the_button_labeled"]?> <strong>"<?=$_["enables_apis_and_services"]?>"</strong> <?=$_["and_click_on_it"]?></li>
																	<br>
																	<li><?=$_["you_will_be_redirected"]?> <strong>"<?=$_["enable"]?>"</strong>,  <?=$_["you_will_be_redirected_to_a_page_when_the_api"]?></li>
																	<br>
																	<li><?=$_["on_the_new_page_click"]?> <strong>"<?=$_["credentials"]?>"</strong>. <?=$_["on_the_next_page_locate_the_drop_down_button_labeled"]?> <strong> "<?=$_["create_credentials"]?>"</strong> <?=$_["click_on_it_and_select_the_drop_down_menu_labeled"]?> <strong>"<?=$_["oauth_client_id"]?>"</strong></li>
																	<br>
																    <li><?=$_["on_the_new_page_click_on>"]?><strong>"<?=$_["configure_consent_screen"]?>" </strong><?=$_["then_check"]?>  <strong>"<?=$_["external"]?>" </strong><?=$_["for_the_user_type"]?> <strong> "<?=$_["internal"]?>"</strong> <?=$_["if_the_account_you_use_is_inside"]?>  <strong>"<?=$_["create"]?>"</strong><br /><?=$_["on_the_new_page_we_have_a_page"]?>
																        <ol>
																		    <br>
																	        <li><?=$_["in_step_1"]?> <strong>"<?=$_["user_support_email"]?>"</strong><?=$_["also_five_your_email_adresse"]?> <strong>"<?=$_["developer_contact_information"]?>"</strong>. <br /><?=$_["you_can_ignore_other_inputs"]?> <strong>"<?=$_["save_and_continue"]?>"</strong></li>
																	        <br>
																	        <li><?=$_["on_step_2"]?> <strong>"<?=$_["save_and_continue"]?>."</strong></li>
																			<br>
																			<li><?=$_["in_step_3"]?> <strong>"<?=$_["save_and_continue"]?>."</strong></li>
																	        <br>
																	        <li><?=$_["in_step_4"]?> <strong>"<?=$_["back_to_dashboard"]?>."</strong></li>
																        </ol>
																    </li>
																	<br>
																	<li><?=$_["on_the_new_page_click_on_the_menu"]?> <strong>"<?=$_["credentials"]?>".</strong> <?=$_["on_the_next_page_locate_the_drop_down_button_labeled"]?> <strong>"<?=$_["create_credentials"]?>"</strong> <?=$_["click_on_it_and_select_the_drop_down_menu_labeled"]?> <strong>"<?=$_["oauth_client_id"]?>"</strong><br /><?=$_["one_the_next_page_select"]?> <strong>"<?=$_["web_application"]?>"</strong> <?=$_["as_the_value_of_the _nput_labeled"]?> <strong> "<?=$_["application_type"]?>"</strong> , <?=$_["give_a_name_to_our_web_application"]?> <strong>"<?=$_["authorized_redirect_uris"]?>",</strong> <?=$_["click_on"]?>  <strong>"<?=$_["add_uri"]?>"</strong>  <?=$_["and_fill_the_input_with_this_value"]?>: https://developers.google.com/oauthplayground <br /><?=$_["click_on"]?> <strong>"<?=$_["create"]?>"</strong><?=$_["to_submit_and_now_we_have_our_client"]?> .<br /></li>
																	<br>
																	<li><?=$_["lets_get_the_refresh_token"]?>. <br /><?=$_["go_to"]?> <a href="https://developers.google.com/oauthplayground" target="_blank">https://developers.google.com/oauthplayground</a><br/><?=$_["for_more_info_how_to_get_refresh_token_watch_this"]?> <a href="https://www.youtube.com/watch?v=FAM_4J7ywcE" target="_blank"><?=$_["video_on_youtube"]?>.</a></li>
																	<br>
																	<li><?=$_["after_getting_refresh_token_you_all_set"]?>.</li>
															    </ol>
														    </div>
														</div>
														<div class="modal-footer">
														    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?=$_["close"]?></button>
														</div>
													</div>
												</div>
											</div><!-- End Modal -->
											
											
									    <?php } ?>
                                        </div> <!-- tab-content -->
                                    </div> <!-- end #basicwizard-->
                                </div> <!-- end card-body -->
                            </div> <!-- end card-->
                        </div> <!-- end col -->
                    </div>
                </form>
            </div> <!-- end container -->
        </div>
        <!-- end wrapper -->
        <?php if ($rSettings["sidebar"]) { echo "</div>"; } ?>
        <!-- Footer Start -->
        <footer class="footer">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 copyright text-center"><?=getFooter()?></div>
                </div>
            </div>
        </footer>
        <!-- end Footer -->
		<link rel="stylesheet" href="assets/js/minified/themes/default.min.css" id="theme-style" />
		<script src="assets/js/minified/sceditor.min.js"></script>
        <script src="assets/js/minified/formats/xhtml.js"></script>						 
        <script src="assets/js/vendor.min.js"></script>
        <script src="assets/libs/jquery-toast/jquery.toast.min.js"></script>
        <script src="assets/libs/jquery-nice-select/jquery.nice-select.min.js"></script>
        <script src="assets/libs/switchery/switchery.min.js"></script>
        <script src="assets/libs/select2/select2.min.js"></script>
        <script src="assets/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
        <script src="assets/libs/bootstrap-maxlength/bootstrap-maxlength.min.js"></script>
        <script src="assets/libs/clockpicker/bootstrap-clockpicker.min.js"></script>
        <script src="assets/libs/moment/moment.min.js"></script>
        <script src="assets/libs/daterangepicker/daterangepicker.js"></script>
        <script src="assets/libs/twitter-bootstrap-wizard/jquery.bootstrap.wizard.min.js"></script>
        <script src="assets/js/pages/form-wizard.init.js"></script>
        <script src="assets/libs/datatables/jquery.dataTables.min.js"></script>
        <script src="assets/libs/datatables/dataTables.bootstrap4.js"></script>
        <script src="assets/libs/datatables/dataTables.responsive.min.js"></script>
        <script src="assets/libs/datatables/responsive.bootstrap4.min.js"></script>
        <script src="assets/libs/datatables/dataTables.buttons.min.js"></script>
        <script src="assets/libs/datatables/buttons.bootstrap4.min.js"></script>
        <script src="assets/libs/datatables/buttons.html5.min.js"></script>
        <script src="assets/libs/datatables/buttons.flash.min.js"></script>
        <script src="assets/libs/datatables/buttons.print.min.js"></script>
        <script src="assets/libs/datatables/dataTables.keyTable.min.js"></script>
        <script src="assets/libs/datatables/dataTables.select.min.js"></script>
        <script src="assets/js/app.min.js"></script>
        
        <script>
        function api(rID, rType) {
            if (rType == "delete") {
                if (confirm('<?=$_["are_you_sure_you_want_to_delete_this_backup"]?>') == false) {
                    return;
                }
            } else if (rType == "restore") {
                if (confirm('<?=$_["are_you_sure_you_want_to_restore_from_this_backup"]?>') == false) {
                    return;
                } else {
					$.toast("<?=$_["restoring_backup"]?>");
					$(".content-page").fadeOut();
				}
            } else if (rType == "backup") {
                $("#create_backup").attr("disabled", true);
			} else if (rType == "download") {
                window.location.href = "./api.php?action=download&filename=" + encodeURIComponent(rID);
            }
            $.getJSON("./api.php?action=backup&sub=" + rType + "&filename=" + encodeURIComponent(rID), function(data) {
                if (data.result === true) {
                    if (rType == "delete") {
                        $.each($('.tooltip'), function (index, element) {
                            $(this).remove();
                        });
                        $('[data-toggle="tooltip"]').tooltip();
                        $.toast("<?=$_["backup_successfully_deleted"]?>");
                    } else if (rType == "restore") {
                        $.toast("<?=$_["restored_from_backup"]?>");
						$(".content-page").fadeIn();
                    } else if (rType == "backup") {
                        $.toast("<?=$_["backup_has_been_successfully_generated"]?>");
                        $("#create_backup").attr("disabled", false);
                    }
					$("#datatable-backups").DataTable().ajax.reload(null, false);
                } else {
                    $.toast("<?=$_["backup_downloading_successfully"]?>");
                    if (rType == "backup") {
                        $("#create_backup").attr("disabled", false);
                    }
					if (!$(".content-page").is(":visible")) {
						$(".content-page").fadeIn();
					}
                }
            });
        }
        $(document).ready(function() {
			$('select').select2({width: '100%'});
            var elems = Array.prototype.slice.call(document.querySelectorAll('.js-switch'));
            elems.forEach(function(html) {
              var switchery = new Switchery(html);
            });
            $(window).keypress(function(event){
                if(event.which == 13 && event.target.nodeName != "TEXTAREA") return false;
            });
			
            $("#datatable-backups").DataTable({
                language: {
                    paginate: {
                        previous: "<i class='mdi mdi-chevron-left'>",
                        next: "<i class='mdi mdi-chevron-right'>"
                    }
                },
                drawCallback: function() {
                    $(".dataTables_paginate > .pagination").addClass("pagination");
                    $('[data-toggle="tooltip"]').tooltip();
                },
				bInfo: false,
				paging: false,
				searching: false,
				bSort: false,
                responsive: false,
				processing: true,
                serverSide: true,
                ajax: {
                    url: "./table_search.php",
                    "data": function(d) {
                        d.id = "backups"
                    }
                },
                order: [[ 0, "desc" ]],
                columnDefs: [
                    {"className": "dt-center", "targets": [0,1,2,3]}
                ],
				
            });
            $("#datatable-backups").css("width", "100%");
            $("form").attr('autocomplete', 'off');
            $("#backups_to_keep").inputFilter(function(value) { return /^\d*$/.test(value); });
        });
		</script>
    </body>
</html>